/*
Version: 1.5, requires Writemonkey 2.7.0.0 or higher

Release date: October 3rd 2014

Author: Josip

Description:  
Save and open password protected files using powerful AES-256 encryption.

Installation:  
Unzip the "Clandestine files" directory into the plugins directory.

Deployment:  
This plugin is initialized at start-up. Use CTRL+E,L to lock currently opened file.
*/


monkey.include("_config.incl");
monkey.include("_config_user.incl");
monkey.include("_ui.incl");


/*
 ######    ##          #######   ########      ###     ##          ######    
##    ##   ##         ##     ##  ##     ##    ## ##    ##         ##    ##   
##         ##         ##     ##  ##     ##   ##   ##   ##         ##         
##   ####  ##         ##     ##  ########   ##     ##  ##          ######    
##    ##   ##         ##     ##  ##     ##  #########  ##               ##   
##    ##   ##         ##     ##  ##     ##  ##     ##  ##         ##    ##   
 ######    ########    #######   ########   ##     ##  ########    ######    
*/
var lockedFilePath_G = "";
var fileToBeOpened_G = "";
var activeSessionPasswords_G = {};
var lastGoodPassword = "";
var setPasswordDialog_G = false;
var setPasswordSecondTime_G = false;
var firstTryPassword_G = null;
var lastSaveHash = "";


// var assembly_G = monkey.pluginDirectoryPath + "/Ionic.Zip.dll";
// var type_G = "Ionic.Zip.ZipFile";



/*
########   ##     ##  ########   ##    ##   ########    ######    
##         ##     ##  ##         ###   ##      ##      ##    ##   
##         ##     ##  ##         ####  ##      ##      ##         
######     ##     ##  ######     ## ## ##      ##       ######    
##          ##   ##   ##         ##  ####      ##            ##   
##           ## ##    ##         ##   ###      ##      ##    ##   
########      ###     ########   ##    ##      ##       ######    
*/
monkey.add_extendedShortcutFiredE(function(object, eventargs) {
	if (eventargs.extendedKey == LOCK_FILE_KEY) {
		// No file to lock
		if (monkey.fileHolder == "-1") {
			monkey.showNotice(CANT_LOCK_S, true, false);
		} else {
			// Check if locked file name already exists. Ask to overwrite ...
			if (System.IO.Path.GetExtension(monkey.fileHolder) != "." + FILE_EXTENSION && System.IO.File.Exists(monkey.fileHolder + "." + FILE_EXTENSION)) {
				// File with the "locked name" already exists
				var msg = FILE_EXISTS_MESSAGE_S.replace("{{name}}", monkey.fileHolder + "." + FILE_EXTENSION);
				var result = System.Windows.Forms.MessageBox.Show(msg, PLUGIN_NAME_S, System.Windows.Forms.MessageBoxButtons.OKCancel);

				if (result == System.Windows.Forms.DialogResult.Cancel) {
					return;
				}
			}
			// lock file
			showSetPassword(monkey.fileHolder);
		}
	}
});


monkey.add_beforeOpenE(function(object, eventargs) {

	// check if wmzip is opened and save it before attempting to open another file
	if (System.IO.Path.GetExtension(monkey.fileHolder) == "." + FILE_EXTENSION) {
		saveWmZip(monkey.fileHolder);
	}

	if (System.IO.Path.GetExtension(eventargs.beforeOpenFileHolder) == "." + FILE_EXTENSION) {
		eventargs.cancel = true;
		fileToBeOpened_G = eventargs.beforeOpenFileHolder;
		
		// Autenticate using "assume the same"
		// check if in activeSessionPasswords_G, if not and "assume the same" --> use last good pswd
		var passwordToUse = "";
		if (activeSessionPasswords_G[eventargs.beforeOpenFileHolder] === undefined && ASK_FOR_PASSWORD == 3 && lastGoodPassword != "") {
			passwordToUse = lastGoodPassword;
		} else {
			passwordToUse = activeSessionPasswords_G[eventargs.beforeOpenFileHolder];
		}

		autenticate(fileToBeOpened_G, passwordToUse);
	} else {
		isLockedFileLoaded_G = false;
		lockedFilePath_G = "";
		fileToBeOpened_G = "";
	}

	return eventargs;
});


monkey.add_beforeSaveE(function(object, eventargs) {
	if (System.IO.Path.GetExtension(monkey.fileHolder) == "." + FILE_EXTENSION) {
		saveWmZip(lockedFilePath_G);
		eventargs.cancel = true;
	} 
	return eventargs;
});


passwordBox.add_KeyDown(function(object, eventargs) {
	resultLabel.Text = CONFIRM_S;

	// ENTER pressed
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;

		if (setPasswordDialog_G) { // set password

			// lock this file
			var oldFile = monkey.fileHolder;
			var newFile = (monkey.fileHolder.EndsWith(FILE_EXTENSION)) ? monkey.fileHolder : monkey.fileHolder + "." + FILE_EXTENSION;

			if (setPasswordSecondTime_G == false) { // entering password first time
				firstTryPassword_G = passwordBox.Text;
				setPasswordSecondTime_G = true;
				showSetPassword(monkey.fileHolder);
			} else { // entering password second time
				if (passwordBox.Text == firstTryPassword_G) { // passwords match

					activeSessionPasswords_G[newFile] = passwordBox.Text;
					saveWmZip(newFile);
					openWmZip(newFile, activeSessionPasswords_G[newFile]);
					// delete unprotected file
					if (DELETE_ORIGINAL_FILE && oldFile != newFile) {
						if (System.IO.File.Exists(oldFile)) {
							System.IO.File.Delete(oldFile);
							monkey.richTextBox.RemoveFromRecentList(oldFile); // remove from recent list
						}
					}
				} else { // passwords doesn't match
					firstTryPassword_G = null;
					setPasswordSecondTime_G = false;
					showSetPassword(monkey.fileHolder);
					resultLabel.Text = PASSWORDS_DONT_MATCH_S;
				}
			}
		} else { // get password
			autenticate(fileToBeOpened_G, passwordBox.Text);
		}
		// ESC pressed
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Escape) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;
		getPasswordForm.Hide();
		setPasswordSecondTime_G = false;
		firstTryPassword_G = null;
		monkey.showNotice("", false, false);
		monkey.richTextBox.Focus();
	}
});



monkey.richTextBox.add_GotFocus(function(object, eventargs) {
	if (getPasswordForm.Visible) {
		getPasswordForm.Focus();
		passwordBox.Focus();
	}
});


// passwordBox.add_TextChanged(function(object, eventargs) {
// });

// monkey.add_appClosingE(function(object, eventargs) {
// });


monkey.form.add_FileNameChanged(function(object, eventargs) {
	if (ASK_FOR_PASSWORD == 1) {
		lastGoodPassword = "";
		if (System.IO.Path.GetExtension(monkey.fileHolder) == "." + FILE_EXTENSION) {
			var currentPassword = activeSessionPasswords_G[monkey.fileHolder];
			activeSessionPasswords_G = {}; // empty session passwords
			activeSessionPasswords_G[monkey.fileHolder] = currentPassword; // set current back
		} else {
			activeSessionPasswords_G = {}; // just empty all session passwords
		}
	} else if (ASK_FOR_PASSWORD == 2) {
		lastGoodPassword = "";
	}
});



/*
##          #######    ######    ####   ######    
##         ##     ##  ##    ##    ##   ##    ##   
##         ##     ##  ##          ##   ##         
##         ##     ##  ##   ####   ##   ##         
##         ##     ##  ##    ##    ##   ##         
##         ##     ##  ##    ##    ##   ##    ##   
########    #######    ######    ####   ######    
*/


// function createNewWmZip(filePath) {
// 	zipInstance_G = monkey.getInstanceFromAssembly(assembly_G, type_G, filePath);
// 	zipInstance_G.Encryption = monkey.getFieldFromAssembly(assembly_G, "Ionic.Zip.EncryptionAlgorithm", ENCRYPTION);

// 	zipInstance_G.Comment = ZIP_FILE_COMMENT_S;
// 	zipInstance_G.Password = tempPassword;
// 	zipInstance_G.AddEntry("document", "", TEXT_ENCODING);
// 	zipInstance_G.AddEntry("metadata", "", TEXT_ENCODING);
// 	zip.Save();
// 	lockedFilePath_G = eventargs.beforeOpenFileHolder;

// }

function showGetPassword(filePath) {
	setPasswordDialog_G = false;

	passwordBox.Clear();
	resultLabel.Text = WRONG_PASSWORD_S;
	passwordLabel.Text = GET_PASSWORD_S + "\n" + System.IO.Path.GetFileName(filePath);
	colorPasswordForm();
	getPasswordForm.Show();
	monkey.richTextBox.Focus();
	monkey.showNotice(FILE_TO_BE_OPENED_S, false, false);

}

function showSetPassword(filePath) {
	setPasswordDialog_G = true;
	var tryNum = (setPasswordSecondTime_G) ? " " + RE_ENTER_S : "";
	passwordBox.Clear();
	resultLabel.Text = CONFIRM_S;
	passwordLabel.Text = SET_PASSWORD_S + "\n" + System.IO.Path.GetFileName(filePath) + tryNum;
	colorPasswordForm();
	getPasswordForm.Show();
	monkey.richTextBox.Focus();
	monkey.showNotice(FILE_TO_BE_OPENED_S, false, false);
}


function autenticate(filePath, password) { // dodaj password parameter
	// check if there is session password for this file

	var result = openWmZip(filePath, password);
	if (result == 1) { // wrong password
		delete activeSessionPasswords_G[filePath];
		showGetPassword(filePath);
	}
}

// Update existing archive
// function updateWmZip(filePath) {
// 	var zip = monkey.getInstanceFromAssembly(assembly_G, type_G, filePath);
// 	zip.Encryption = monkey.getFieldFromAssembly(assembly_G, "Ionic.Zip.EncryptionAlgorithm", ENCRYPTION);
// 	zip.Comment = ZIP_FILE_COMMENT_S;
// 	zip.Password = sessionPassword_G;

// 	zip.UpdateEntry("document", monkey.mainText, TEXT_ENCODING);
// 	zip.UpdateEntry("repository", monkey.repositoryText, TEXT_ENCODING);
// 	zip.UpdateEntry("metadata", "some JSON", TEXT_ENCODING);

// 	zip.Save();
// 	zip.Dispose(); // important!

// 	setSaveParams();
// 	monkey.showNotice(FILE_SAVED_S, true, false);
// }


function saveWmZip(filePath) {

	// skip if document hasn't changed since last save
	if (saveNeeded() == false) {
		return; // Abort!
	}
	

	monkey.form.watcher.EnableRaisingEvents = false; // because of atomics save (rename first)

	// Delete old file if exists
	// if (System.IO.File.Exists(filePath)) {
	// 	System.IO.File.Delete(filePath);
	// }

	//var zip = monkey.getInstanceFromAssembly(assembly_G, type_G, filePath);
	var zip = monkey.getIonicZipInstance(filePath);

	//zip.Encryption = monkey.getFieldFromAssembly(assembly_G, "Ionic.Zip.EncryptionAlgorithm", ENCRYPTION);
	zip.Encryption = monkey.getZipEncryptionAlgorithm(ENCRYPTION);

	zip.Comment = ZIP_FILE_COMMENT_S;
	zip.Password = activeSessionPasswords_G[filePath];



	// check if file exists, delete old entries
	if (System.IO.File.Exists(filePath)) {
		zip.RemoveEntry("document");
		zip.RemoveEntry("repository");
		zip.RemoveEntry("metadata");
	}
	

	zip.AddEntry("document", monkey.mainText, TEXT_ENCODING);
	zip.AddEntry("repository", monkey.repositoryText, TEXT_ENCODING);
	zip.AddEntry("metadata", monkey.selectionStart.ToString(), TEXT_ENCODING);
	

	zip.Save(filePath);

	zip.Dispose();
	setSaveParams();
	monkey.showNotice(FILE_SAVED_S, true, false);
	lastSaveHash = getTextHash(monkey.document);

	monkey.form.watcher.EnableRaisingEvents = true; // because of atomics save (rename first)
}

// returns result / 0=ok, 1=wrongpassword

function openWmZip(filePath, password) { // returns error flags

	var retValue = 0;
	//var zip = monkey.getInstanceFromAssembly(assembly_G, type_G, filePath);
	var zip = monkey.getIonicZipInstance(filePath);

	var memoryStreamDocument = new System.IO.MemoryStream();
	var memoryStreamRepository = new System.IO.MemoryStream();
	var memoryStreamMetadata = new System.IO.MemoryStream();


	var documentEntry = zip["document"];
	var repositoryEntry = zip["repository"];
	var metadataEntry = zip["metadata"];


	// try to export with provided password
	try {
		documentEntry.ExtractWithPassword(memoryStreamDocument, password);
		repositoryEntry.ExtractWithPassword(memoryStreamRepository, password);
		metadataEntry.ExtractWithPassword(memoryStreamMetadata, password);
	} catch (passE) {
		retValue = 1;
		zip.Dispose(); // important!
		return retValue;
	}

	memoryStreamDocument.Position = 0;
	memoryStreamRepository.Position = 0;
	memoryStreamMetadata.Position = 0;

	var srDocument = new System.IO.StreamReader(memoryStreamDocument, TEXT_ENCODING);
	var srRepository = new System.IO.StreamReader(memoryStreamRepository, TEXT_ENCODING);
	var srMetadata = new System.IO.StreamReader(memoryStreamMetadata, TEXT_ENCODING);

	var strDocument = srDocument.ReadToEnd();
	var strRepository = srRepository.ReadToEnd();
	var strMetadata = srMetadata.ReadToEnd();

	memoryStreamDocument.Dispose();
	memoryStreamRepository.Dispose();
	memoryStreamMetadata.Dispose();
	zip.Dispose(); // important!

	// important
	// if (retValue != 0) 
	// 	return retValue;

	resultLabel.Text = "";
	passwordBox.Clear();
	getPasswordForm.Hide(); // close prompt
	lockedFilePath_G = filePath;


	monkey.richTextBox.ResetTextHolders();
	// file successfully opened, set stuff
	monkey.mainText = strDocument; // set main and repo text
	monkey.repositoryText = strRepository;

	if (!isNaN(parseInt(strMetadata)))
		monkey.select(parseInt(strMetadata), 0);

	monkey.performSyntaxColoring();
	monkey.richTextBox.ScrollToCaret();
	monkey.form.PositionScrollMarker();
	monkey.resumeLayout();
	monkey.richTextBox.Invalidate();

	monkey.richTextBox.fileHolder = lockedFilePath_G;
	monkey.richTextBox.fileName = System.IO.Path.GetFileName(lockedFilePath_G);
	monkey.form.SetFileNameInControllBox();
	monkey.form.__SetFileName();

	setSaveParams();
	monkey.richTextBox.StoreRecentFile(filePath);
	monkey.showNotice(FILE_OPENED_S, true, false);
	monkey.richTextBox.Focus();

	// save session password
	activeSessionPasswords_G[filePath] = password;
	lastGoodPassword = password;
	lastSaveHash = getTextHash(monkey.document);

	return retValue;
}



/*
##     ##  ########   ##         ########   ########   ########    ######    
##     ##  ##         ##         ##     ##  ##         ##     ##  ##    ##   
##     ##  ##         ##         ##     ##  ##         ##     ##  ##         
#########  ######     ##         ########   ######     ########    ######    
##     ##  ##         ##         ##         ##         ##   ##          ##   
##     ##  ##         ##         ##         ##         ##    ##   ##    ##   
##     ##  ########   ########   ##         ########   ##     ##   ######    
*/

function setSaveParams() {
	monkey.richTextBox.LastSave = monkey.dateTimeNow;
	monkey.richTextBox.textSaved = true;
	monkey.richTextBox.textChanged = false;
	monkey.richTextBox.MD5flag = monkey.richTextBox.GetMd5Sum(monkey.richTextBox.PrepareForSave());
}

function colorPasswordForm() {
	getPasswordForm.BackColor = monkey.dimmedColor;
	passwordLabel.ForeColor = monkey.paperColor;
	passwordLabel.BackColor = monkey.dimmedColor;
	separatorPanel.BackColor = monkey.dimmedColor;
	resultLabel.ForeColor = monkey.paperColor;
	resultLabel.BackColor = monkey.dimmedColor;
	passwordBox.BackColor = monkey.dimmedColor;
	passwordBox.ForeColor = monkey.paperColor;
}



function saveNeeded() {
	return (lastSaveHash == getTextHash(monkey.document)) ? false : true;
}


function getTextHash(text) {
	if (text.length <= 0) {
		return "0";
	} else {
		return monkey.richTextBox.GetMd5Sum(text);
	}
}


// function pwdStrength(password) {
// 	var score = 0;

// 	var length  = password.length;
// 	var lower   = (password.match(/[a-z]/g)||[]).length;
// 	var upper   = (password.match(/[A-Z]/g)||[]).length;
// 	var number  = (password.match(/\d+/g)||[]).length;
// 	var special = (password.match(/.[!,@,#,$,%,^,&,*,?,_,~,-,(,)]/g)||[]).length;

// 	return score;

// }